% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_func_scans}
\alias{check_func_scans}
\title{Check Functional Scans in a BIDS Project}
\usage{
check_func_scans(x)
}
\arguments{
\item{x}{A \code{bids_project} object created by \code{bids_project()}.}
}
\value{
A list containing:
\itemize{
\item \code{scans}: A tibble with details of all functional scans, including:
\itemize{
\item Subject ID
\item Task name
\item Run number
\item File size
\item Full file path
}
\item \code{tasklist}: A vector of unique tasks found in the project
\item \code{scans_per_subject}: A summary tibble showing the number of scans per subject
}

If multiple tasks are present, also includes:
\itemize{
\item \code{scans_per_task}: Summary of scan counts by task
\item \code{scans_per_task_subject}: Summary of scan counts by subject and task
\item \code{size_per_task}: Tibble with file size statistics by task
}

If only one task is present:
\itemize{
\item \code{size_per_subject}: Tibble with file size statistics by subject
}
}
\description{
This function performs a comprehensive inspection of functional scans within a BIDS project,
providing detailed summaries of scan counts and file sizes per subject and task. It helps
identify potential issues such as missing scans, inconsistent file sizes, or unexpected
variations in the data.
}
\examples{
\donttest{
# Check functional scans in a BIDS dataset
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  scan_check <- check_func_scans(proj)
  print(scan_check)
  
  # Filter for specific subjects
  sub01_check <- check_func_scans(proj, subid="01")
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}

}
