% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-plots_and_app.R
\name{plot_venn}
\alias{plot_venn}
\title{Plotting Venn Diagram from biblioverlap results}
\usage{
plot_venn(db_list, ...)
}
\arguments{
\item{db_list}{\itemize{
\item list of matched dataframes (with UUID column added by biblioverlap)
}}

\item{...}{\itemize{
\item Additional arguments that can be passed down to \code{\link[ggVennDiagram:ggVennDiagram]{ggVennDiagram::ggVennDiagram()}}
}}
}
\value{
a Venn Diagram representation of document overlap between the input datasets
}
\description{
Plotting Venn Diagram from biblioverlap results
}
\examples{
#Running document-level matching procedure
biblioverlap_results <- biblioverlap(ufrj_bio_0122[1:2])

#Checking biblioverlap results (db_list)
lapply(biblioverlap_results$db_list, head, n=1)

#Plotting the Venn diagram
plot_venn(biblioverlap_results$db_list)

}
