% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbgumbel.R
\name{pbgumbel}
\alias{pbgumbel}
\title{Bimodal Gumbel: Distribution Function}
\usage{
pbgumbel(q, mu, sigma, delta, lower.tail = TRUE)
}
\arguments{
\item{q}{Quantile.}

\item{mu}{First location parameter.}

\item{sigma}{Scale parameter.}

\item{delta}{Second location parameter.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P(X <= x) otherwise, P(X > x).}
}
\value{
Vector.
}
\description{
Bimodal Gumbel: Distribution Function
}
\examples{
pbgumbel(0, mu = -2, sigma = 1, delta = -1)
integrate(dbgumbel, mu = -2, sigma = 1, delta = -1, lower = -Inf, upper = 0)
pbgumbel(0, mu = -2, sigma = 1, delta = -1, lower.tail = FALSE)
curve(pbgumbel(x, mu = -2, sigma = 1, delta = -1), xlim = c(-5, 10))
}
