% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfsl.R
\name{predict.bfsl}
\alias{predict.bfsl}
\title{Predict Method for bfsl Model Fits}
\usage{
\method{predict}{bfsl}(
  object,
  newdata,
  interval = c("none", "confidence"),
  level = 0.95,
  se.fit = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{"bfsl"}.}

\item{newdata}{A data frame with variable \code{x} to predict.
If omitted, the fitted values are used.}

\item{interval}{Type of interval calculation. \code{"none"} or \code{"confidence"}.}

\item{level}{Confidence level.}

\item{se.fit}{A switch indicating if standard errors are returned.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\code{predict.bfsl} produces a vector of predictions or a matrix of
predictions and bounds with column names \code{fit}, \code{lwr}, and \code{upr}
if interval is set to \code{"confidence"}.

If \code{se.fit} is \code{TRUE}, a list with the following components is returned:
\tabular{ll}{
\code{fit} \tab Vector or matrix as above \cr
\code{se.fit} \tab Standard error of predicted means
}
}
\description{
\code{predict.bfsl} predicts future values based on the bfsl fit.
}
\examples{
fit = bfsl(pearson_york_data)
predict(fit, interval = "confidence")
new = data.frame(x = seq(0, 8, 0.5))
predict(fit, new, se.fit = TRUE)

pred.clim = predict(fit, new, interval = "confidence")
matplot(new$x, pred.clim, lty = c(1,2,2), type = "l", xlab = "x", ylab = "y")
df = fit$data
points(df$x, df$y)
arrows(df$x, df$y-df$sd_y, df$x, df$y+df$sd_y,
       length = 0.05, angle = 90, code = 3)
arrows(df$x-df$sd_x, df$y, df$x+df$sd_x, df$y,
       length = 0.05, angle = 90, code = 3)

}
