% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Listener.R
\docType{class}
\name{Listener}
\alias{Listener}
\title{Listener Class}
\format{
An [`R6::R6Class`] generator for `Listener` objects.
}
\description{
A `Listener` object represents an event handler within a [`Router`].
Each listener pairs an `event` type (e.g., `"start"`, `"error"`, `"finish"`)
with a function `FUN` to execute when that event is triggered.
}
\seealso{
[Router], [Error]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{FUN}}{Handler function to execute when `event` is triggered.}

\item{\code{event}}{Event name (e.g., `"start"`, `"error"`, `"finish"`).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Listener-new}{\code{Listener$new()}}
\item \href{#method-Listener-clone}{\code{Listener$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listener-new"></a>}}
\if{latex}{\out{\hypertarget{method-Listener-new}{}}}
\subsection{Method \code{new()}}{
Construct a listener by setting its `event` and handler `FUN`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listener$new(event, FUN, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{Event name string.}

\item{\code{FUN}}{Function to call when the event occurs.}

\item{\code{...}}{Ignored; accepted for flexibility.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listener-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Listener-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listener$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
