% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.clogit_bclogit.R
\name{vcov.clogit_bclogit}
\alias{vcov.clogit_bclogit}
\title{Extract variance-covariance matrix from a clogit_bclogit model}
\usage{
\method{vcov}{clogit_bclogit}(object, ...)
}
\arguments{
\item{object}{A \code{clogit_bclogit} object.}

\item{...}{Additional arguments.}
}
\value{
A diagonal matrix of the estimated coefficient variances (squared standard
errors), or \code{NULL} when \code{do_inference_on_var} is not \code{"all"}.
}
\description{
Extract variance-covariance matrix from a clogit_bclogit model
}
\examples{
n <- 200
dat <- data.frame(
  y = rbinom(n, 1, 0.5),
  x1 = rnorm(n),
  treatment = rep(c(0, 1), n / 2),
  strata = rep(seq_len(n / 2), each = 2)
)
fit <- clogit(y ~ x1, data = dat, treatment = treatment, strata = strata)
vcov(fit)
}
\seealso{
\code{\link{coef.clogit_bclogit}}, \code{\link{summary.clogit_bclogit}}
}
