% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.clogit_bclogit.R
\name{summary.clogit_bclogit}
\alias{summary.clogit_bclogit}
\title{Summarize a clogit_bclogit model}
\usage{
\method{summary}{clogit_bclogit}(object, ...)
}
\arguments{
\item{object}{A \code{clogit_bclogit} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A list of class \code{"summary.clogit_bclogit"} containing:
\item{call}{The original function call.}
\item{coefficients}{A matrix with one row per parameter and columns \code{Estimate},
\code{Std. Error}, \code{z value}, and \code{Pr(>|z|)}.}
\item{num_discordant}{Number of discordant pairs used for fitting.}
\item{num_concordant}{Number of concordant pairs.}
\item{n}{Total number of observations.}
\item{treatment_name}{Name of the treatment variable.}
\item{do_inference_on_var}{The value of the \code{do_inference_on_var} argument.}
}
\description{
Summarize a clogit_bclogit model
}
\examples{
n <- 200
dat <- data.frame(
  y = rbinom(n, 1, 0.5),
  x1 = rnorm(n),
  treatment = rep(c(0, 1), n / 2),
  strata = rep(seq_len(n / 2), each = 2)
)
fit <- clogit(y ~ x1, data = dat, treatment = treatment, strata = strata)
summary(fit)
}
\seealso{
\code{\link{clogit}}, \code{\link{print.summary.clogit_bclogit}},
\code{\link{coef.clogit_bclogit}}, \code{\link{vcov.clogit_bclogit}}
}
