% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.bclogit.R
\name{confint.bclogit}
\alias{confint.bclogit}
\title{Credible Intervals for bclogit Parameters}
\usage{
\method{confint}{bclogit}(object, parm, level = 0.95, type = c("HPD_one", "CR", "HPD_many"), ...)
}
\arguments{
\item{object}{A \code{bclogit} object.}

\item{parm}{A specification of which parameters to be given credible intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{The confidence level required (default 0.95).}

\item{type}{Type of interval to compute: "HPD_one" (default unimodal HPD interval via coda), "CR" (equal-tailed credible region), "HPD_many" (multimodal HPD interval via ggdist).}

\item{...}{Additional arguments.}
}
\value{
A matrix with columns \code{lower} and \code{upper}.
For \code{"HPD_many"}, a parameter may appear on multiple rows when the interval is disjoint.
The matrix has a \code{Probability} attribute.
}
\description{
Computes Bayesian credible intervals for the model parameters.
}
\seealso{
\code{\link{summary.bclogit}}, \code{\link{coef.bclogit}}
}
