% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.bclogit.R
\name{coef.bclogit}
\alias{coef.bclogit}
\title{Extract coefficients from a bclogit model}
\usage{
\method{coef}{bclogit}(object, ...)
}
\arguments{
\item{object}{A \code{bclogit} object.}

\item{...}{Additional arguments.}
}
\value{
Named numeric vector of posterior mean coefficients.
}
\description{
Extract coefficients from a bclogit model
}
\examples{
\donttest{
data("fhs")
fit <- bclogit(PREVHYP ~ TOTCHOL + BMI, data = fhs,
               treatment = PERIOD, strata = RANDID)
coef(fit)
}
}
\seealso{
\code{\link{vcov.bclogit}}, \code{\link{summary.bclogit}}
}
