% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{blockBGR}
\alias{blockBGR}
\title{Bayesian graphical ridge block Gibbs sampler for Gaussian graphical models.}
\usage{
blockBGR(X, burnin, iterations, sig = 1, verbose = TRUE)
}
\arguments{
\item{X}{A numeric matrix, assumed to be generated from a multivariate Gaussian distribution.}

\item{burnin}{An integer representing the number of burn-in iterations.}

\item{iterations}{An integer representing the length of the Markov chain post burn-in.}

\item{sig}{A numeric value representing the standard deviation parameter for the double
Gaussian and truncated Gaussian prior.}

\item{verbose}{A logical indicating if the MCMC sampler progress should be printed.}
}
\value{
A list containing precision `Omega` and covariance `Sigma` matrices
from the Markov chains.
}
\description{
Implements a Bayesian graphical ridge block Gibbs sampler to simulate the
posterior distribution of the precision matrix for Gaussian graphical models.
}
\examples{
# Generate true precision matrix:
p             <- 10
n             <- 500
OmegaTrue    <- pracma::Toeplitz(c(0.7^rep(1:p-1)))
SigTrue      <- pracma::inv(OmegaTrue)
# Generate expected value vector:
mu            <- rep(0,p)
# Generate multivariate normal distribution:
set.seed(123)
X             <- MASS::mvrnorm(n, mu = mu, Sigma = SigTrue)
# Generate posterior distribution:
posterior     <- blockBGR(X, iterations = 1000, burnin = 500, sig = 0.5)
# Estimated precision matrix using the mean of the posterior:
OmegaEst      <- apply(simplify2array(posterior$Omega), 1:2, mean)
}
