% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_moma_sample.R
\docType{data}
\name{moma_sample}
\alias{moma_sample}
\title{Museum of Modern Art (MoMA) data sample}
\format{
A data frame with 100 rows and 10 variables. Each row represents an individual artist in the MoMA collection.
\describe{
  \item{artist}{name}
  \item{country}{country of origin}
  \item{birth}{year of birth}
  \item{death}{year of death}
  \item{alive}{whether or not the artist was living at the time of data collection (December 2020)}
  \item{genx}{whether or not the artist is Gen X or younger, ie. born during 1965 or after}
  \item{gender}{gender identity (as perceived by MoMA employees)}
  \item{count}{number of the artist's works in the MoMA collection}
  \item{year_acquired_min}{first year MoMA acquired one of the artist's works}
  \item{year_acquired_max}{most recent year MoMA acquired one of the artist's works}
  }
}
\source{
\url{https://github.com/MuseumofModernArt/collection/blob/master/Artworks.csv/}.
}
\usage{
moma_sample
}
\description{
A random sample of 100 artists represented in the Museum of Modern Art in New York City.
The data was made available by MoMA itself and downloaded in December 2020.
It does not include information about artist collectives or companies.
}
\keyword{datasets}
