% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.lm_b}
\alias{summary.aov_b}
\alias{summary.np_glm_b}
\alias{summary.lm_b_bma}
\alias{summary.glm_b}
\alias{summary.mediate_b}
\title{Summary functions for bayesics objects}
\usage{
\method{summary}{lm_b}(object, CI_level = 0.95, ...)

\method{summary}{aov_b}(object, CI_level = 0.95, ...)

\method{summary}{np_glm_b}(object, CI_level = 0.95, interpretable_scale = TRUE, ...)

\method{summary}{lm_b_bma}(object, CI_level = 0.95, ...)

\method{summary}{glm_b}(object, CI_level = 0.95, interpretable_scale = TRUE, ...)

\method{summary}{mediate_b}(object, CI_level = 0.95, ...)
}
\arguments{
\item{object}{bayesics object}

\item{CI_level}{Posterior probability covered by credible interval}

\item{...}{optional arguments.}

\item{interpretable_scale}{ADD description!}
}
\value{
tibble with summary values
}
\description{
Summary functions for bayesics objects
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
summary(fit1)
}

}
