% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{irf}
\alias{irf}
\title{Impulse response functions}
\usage{
irf(
  x,
  ahead = 8,
  structural_restrictions = NULL,
  shocks = NULL,
  hairy = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of type \code{bayesianVARs_bvar}.}

\item{ahead}{maximum number of time horizons.}

\item{structural_restrictions}{an object generated by \code{\link{specify_structural_restrictions}}. If specified,
the IRFs to the structural shocks identified by the restrictions given in this argument will be calculated.
If not specified, the orthogonal IRFs based on the Cholesky decomposition will be calculated.
Note that the orthogonal IRFs depend on the ordering of the variables and do not necessarily
correspond to shocks with a meaningful interpretation.}

\item{shocks}{an matrix with r rows, where r is the number of shocks (see 'Details'). Each column specifies a shock.
Default: \code{diag(r)}, will calculate the responses to all structural (or factor) shocks of one standard deviation.}

\item{hairy}{set to \code{TRUE} in order to plot each path seperately.
To show valid quantiles, an Bayes optimal order of the posterior samples will be calculated which can take a long time
even for moderately many samples. Default: \code{FALSE}.}

\item{...}{Following expert arguments can be specified:
\describe{
\item{solver:}{\code{"randomized"} or \code{"lp"}. If some columns have more than one sign restriction, \code{"lp"}
might find a solution, even if \code{"randomized"} is unable to. However \code{"lp"} can produce artifically narrow confidence bands
which do not properly reflect the uncertainty in the identification scheme. Default: \code{"randomized"}}
\item{randomized_max_rotations_per_sample:}{if using the \code{"randomized"} solver, how many rotations are drawn for each sample of
the reduced form parameters in \code{x}. Default: \code{2}.}
}}
}
\value{
Returns a \code{bayesianVARs_irf} object.
}
\description{
Effect of the structural (factor) shocks over time.
}
\details{
If a factor model was used, then the number of shocks is equal to the number
of factors.

If the Cholesky model was used, then the number of shocks is equal to the
number of variables.
}
\examples{
train_data <- 100 * usmacro_growth[,c("GDPC1", "GDPCTPI", "GS1", "M2REAL", "CPIAUCSL")]
prior_sigma <- specify_prior_sigma(train_data, type="cholesky", cholesky_heteroscedastic=FALSE)
mod <- bvar(train_data, lags=5L, prior_sigma=prior_sigma, quiet=TRUE)

structural_restrictions <- specify_structural_restrictions(
 mod,
 restrictions_B0=rbind(
   c(1 ,NA,0 ,NA,NA),
   c(0 ,1 ,0 ,NA,NA),
   c(0 ,NA,1 ,NA,NA),
   c(0 ,0 ,NA,1 ,NA),
   c(0 ,0 ,0 ,0 ,1 )
 )
)
irf_structural <- irf(
 mod, ahead=8,
 structural_restrictions=structural_restrictions
)
plot(irf_structural)

}
\references{
Arias, J. and Rubio-Ramírez, J. and Waggoner, D. (2014).
Inference Based on SVARs Identified with Sign and Zero Restrictions: Theory and Applications.
\emph{FRB Atlanta Working Paper Series}, \doi{10.2139/ssrn.2580264}.
}
\seealso{
\code{\link{specify_structural_restrictions}}, \code{\link{extractB0}}
}
\author{
Stefan Haan \email{sthaan@edu.aau.at}
}
