% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rec.bayesian.R
\name{rec.bayesian}
\alias{rec.bayesian}
\title{This function generate temperature predictions (in 10^6/T2) based on a
calibration dataset and target D47. Note that this approach additionally
accounts for measured error in the target D47. This approach is congruent
with the one used in McClelland et al. (2022).}
\usage{
rec.bayesian(
  calModel,
  recData,
  iter = 1000,
  mixed = FALSE,
  postcalsamples = NULL,
  MC = TRUE
)
}
\arguments{
\item{calModel}{The stan model to be analyzed.}

\item{recData}{The reconstruction dataset.}

\item{iter}{Number of replicates to retain.}

\item{mixed}{whether the model \code{calModel} is mixed or not.}

\item{postcalsamples}{Number of posterior samples to analyze from the calibration step.}

\item{MC}{Multicore (TRUE/FALSE)}
}
\value{
a \code{data.frame} with temperature reconstructions and the
        original values used in the reconstruction.
}
\description{
This function generate temperature predictions (in 10^6/T2) based on a
calibration dataset and target D47. Note that this approach additionally
accounts for measured error in the target D47. This approach is congruent
with the one used in McClelland et al. (2022).
}
