% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/batman.R
\name{to_logical}
\alias{to_logical}
\title{Convert categorical representations of true/false values to a logical}
\usage{
to_logical(x, language = "en", custom_true = character(),
  custom_false = character())
}
\arguments{
\item{x}{a vector of categorical TRUE/FALSE/NA values.}

\item{language}{the language to use. See \code{get_languages} for the list
of supported languages. If your language is not supported, you can use
\code{custom_true} and \code{custom_false} to provide values.}

\item{custom_true}{a vector of values to consider, in addition to the ones
\code{to_logical} already recognises, TRUE. Empty by default. Note that
the comparison code is case-insensitive, so there's no need to include
(for example) both "ja" and "Ja".}

\item{custom_false}{a vector of values to consider, in addition to the ones
\code{to_logical} already recognises, FALSE. Empty by default; see the notes
on case sensitivity above.}
}
\description{
\code{to_logical} is designed for the situation where you have categorical data
(perhaps from a survey, or direct user input) that represents TRUE/FALSE values as something
other than TRUE/FALSE - "Yes", "No", "None", "Y" or "False", say. With \code{to_logical}
you can easily convert a vector of these values into an actual, logical vector, using
either a predefined set of accepted TRUE or FALSE equivalents, or a set you specify
yourself.
}
\examples{
# A very simple example using the pre-known true and false equivalents
categorical_values <- c("true","t","y","yes","f","no","1")
to_logical(categorical_values)

# Use a custom specifier
categorical_values <- c("NA","NA","NA","NA","NA","NA","NA","NA","Batman")
to_logical(categorical_values, custom_true = c("Batman"))
}

