% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results.R
\name{get_results.bhm}
\alias{get_results.bhm}
\title{Get Results for Simulation of a Basket Trial with the BHM Design}
\usage{
\method{get_results}{bhm}(
  design,
  n,
  p1 = NULL,
  lambda,
  tau_scale,
  iter = 1000,
  n_mcmc = 10000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{bhm}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{tau_scale}{Standard deviation of the half normal prior distribution
for the variance of the thetas.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{n_mcmc}{Number of MCMC samples.}

\item{data}{An object of class \code{scenario_list} as returned by the
function \code{bhmbasket::simulateScenarios}.}

\item{...}{Further arguments.}
}
\value{
A matrix of results with \code{iter} rows. A 0 means, that the
null hypothesis that the response probability exceeds \code{p0} was not
rejected, a 1 means, that the null hypothesis was rejected.
}
\description{
Get Results for Simulation of a Basket Trial with the BHM Design
}
\examples{
\donttest{
design <- setup_bhm(k = 3, p0 = 0.2, p_target = 0.5)

# Equal sample sizes
get_results(design, n = 20, p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, tau_scale = 1, iter = 100)

# Unequal sample sizes
get_results(design, n = c(15, 20, 25), p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, tau_scale = 1, iter = 100)
}
}
