% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcv.R
\name{bases_mgcv}
\alias{bases_mgcv}
\title{\code{mgcv} integration}
\description{
Provides methods so that \code{bases} expansions can be used as user-defined
smooth classes in \code{\link[mgcv:s]{mgcv::s()}}.
The \code{k} argument to \code{s()} maps to the main dimension parameter of each basis.
Other arguments should be passed via the \code{xt} argument to \code{s()}, and will be
forwarded to the basis function.
}
\examples{
if (requireNamespace("mgcv", quietly = TRUE)) {
    x = 1:150
    z = c(1:50, rep(1, 100))
    y = as.numeric(BJsales)
    m = mgcv::gam(y ~ s(x, bs = "b_bart", k=10) + s(z, bs = "b_bart", k=20))
    summary(m)
    plot(x, y)
    lines(x, fitted(m), type="s", col="blue")
}

}
\concept{interfaces}
