% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_nn.R
\name{b_nn}
\alias{b_nn}
\title{Neural network basis}
\usage{
b_nn(
  ...,
  p = 100,
  activation = function(x) (x + abs(x))/2,
  stdize = c("scale", "box", "symbox", "none"),
  weights = NULL,
  biases = NULL,
  shift = NULL,
  scale = NULL
)
}
\arguments{
\item{...}{The variable(s) to build features for. A single data frame or
matrix may be provided as well. Missing values are not allowed.}

\item{p}{The number of random features.}

\item{activation}{The activation function, which should take in a numeric
vector and return another of the same length. The default is the rectified
linear unit, i.e. \code{pmax(0, x)}; the implementation here is faster.}

\item{stdize}{How to standardize the predictors, if at all. The default
\code{"scale"} applies \code{scale()} to the input so that the features have mean
zero and unit variance, \code{"box"} scales the data along each dimension
to lie in the unit hypercube, and \code{"symbox"} scales the data along each
dimension to lie in \eqn{[-0.5, 0.5]^d}.}

\item{weights}{Matrix of weights; \code{nrow(weights)} must match the number of
predictors. If provided, overrides those calculated automatically, thus
ignoring \code{p}.}

\item{biases}{Vector of biases to use. If provided, overrides those
calculated automatically, thus ignoring \code{p}.}

\item{shift}{Vector of shifts, or single shift value, to use. If provided,
overrides those calculated according to \code{stdize}.}

\item{scale}{Vector of scales, or single scale value, to use. If provided,
overrides those calculated according to \code{stdize}.}
}
\value{
A matrix of random neural network features.
}
\description{
Generates random features from a one-layer neural network, i.e., a random
linear transformation followed by a nonlinear activation function: \deqn{
  \phi(x) = g(w^\top x + b),
} where \emph{w} and \emph{b} are randomly sampled weights and bias, and \emph{g} is the
chosen activation function.
}
\details{
As with \code{\link[=b_rff]{b_rff()}}, to reduce the variance, a moment-matching transformation
is applied to ensure the sampled weights and biases have mean zero and the
sampled weights have unit covariance.
}
\examples{
data(quakes)

m = ridge(depth ~ b_nn(lat, long, p = 100, activation = tanh), quakes)
plot(fitted(m), quakes$depth)

# In 1-D with ReLU (default), equivalent to piecewise
# linear regression with random knots
x = 1:150
y = as.numeric(BJsales)
m = lm(y ~ b_nn(x, p = 8))
plot(x, y)
lines(x, fitted(m), col="blue")
}
