% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_uncertainty.R
\name{.calc_n_retro_nowcast_times}
\alias{.calc_n_retro_nowcast_times}
\title{Calculate the number of retrospective nowcast times that can be used after
aggregating}
\usage{
.calc_n_retro_nowcast_times(
  list_of_obs,
  n_possible_horizons,
  ref_time_aggregator = identity
)
}
\arguments{
\item{list_of_obs}{List of matrices of truncated reporting triangles}

\item{n_possible_horizons}{Integer indicating the number of horizons in the
retrospective reporting triangle.}

\item{ref_time_aggregator}{Function that operates along the rows (reference
times) of the retrospective point nowcast matrix before it has been
aggregated across columns (delays). Default is \code{identity}
which does not aggregate across reference times.}
}
\value{
\code{n_iters} Integer indicating the number of iterations, or
number of retrospective nowcast times, that have sufficient data once
aggregated to be used to generate a retrospective point nowcast.
}
\description{
Calculate the number of retrospective nowcast times that can be used after
aggregating
}
\keyword{internal}
