% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fg_fielder_leaders.R
\name{fg_fielder_leaders}
\alias{fg_fielder_leaders}
\title{\strong{Scrape Fielder Leaderboards from FanGraphs}}
\usage{
fg_fielder_leaders(
  age = "",
  pos = "all",
  stats = "fld",
  lg = "all",
  qual = "0",
  startseason = "2023",
  endseason = "2023",
  startdate = "",
  enddate = "",
  month = "0",
  hand = "",
  team = "0",
  pageitems = "10000",
  pagenum = "1",
  ind = "0",
  rost = "0",
  players = "",
  type = "1",
  postseason = "",
  sortdir = "default",
  sortstat = "Defense"
)
}
\arguments{
\item{age}{(integer) Age of players}

\item{pos}{(character) Position of players, defaults to "all". To exclude pitchers, use "np".}

\item{stats}{(character) Statistic to return. Defaults to "bat".}

\item{lg}{(character) League to return. Defaults to "all". Options are "al", "nl", or "all".}

\item{qual}{(character) Whether you want only batters/pitchers that qualified in a given season, or the minimum number of plate appearances for inclusion. If you only want qualified hitters, use qual. If a minimum number of plate appearaces/innings pitched, use the number desired. Defaults to "y".}

\item{startseason}{(character) Season for which you want to scrape the data.}

\item{endseason}{(character) Last season for which you want data.}

\item{startdate}{(character) Start date for which you want data.}

\item{enddate}{(character) End date for which you want data.}

\item{month}{(character) Month for which you want data.}

\item{hand}{(character) Handedness of batter. Options are "L", "R", or "B". Empty string returns all.}

\item{team}{(character) Teams for which you want data, comma separated.}

\item{pageitems}{(character) Number of items per page.}

\item{pagenum}{(character) Page number.}

\item{ind}{(character) Whether or not to break the seasons out individual, or roll them up together. 1 = split seasons, 0 = aggregate seasons.}

\item{rost}{(character) Whether or not to include players on the roster. 1 = include, 0 = exclude.}

\item{players}{(character) Whether or not to include players on the roster. 1 = include only active roster players, 0 = exclude.}

\item{type}{(character) Defaults to 8, which is the standard leaderboard. The values for the leaderboards appear to go to from type = 0 to 48+, which correspond to links on the leaderboard page.}

\item{postseason}{(logical) Whether or not to include postseason data. TRUE = include postseason, FALSE = exclude postseason.}

\item{sortdir}{(character) Sort direction. Options are "asc" or "desc" or "default".}

\item{sortstat}{(character) Sort by stat. Default is "Defense".}
}
\value{
A data frame of fielder data.\tabular{ll}{
   col_name \tab types \cr
   Season \tab integer \cr
   team_name \tab character \cr
   xMLBAMID \tab integer \cr
   PlayerNameRoute \tab character \cr
   PlayerName \tab character \cr
   playerid \tab integer \cr
   SeasonMin \tab integer \cr
   SeasonMax \tab integer \cr
   Pos \tab character \cr
   G \tab integer \cr
   GS \tab integer \cr
   Inn \tab numeric \cr
   PO \tab integer \cr
   A \tab integer \cr
   E \tab integer \cr
   FE \tab integer \cr
   TE \tab integer \cr
   DP \tab integer \cr
   DPS \tab integer \cr
   DPT \tab integer \cr
   DPF \tab integer \cr
   SB \tab integer \cr
   CS \tab integer \cr
   PB \tab integer \cr
   WP \tab integer \cr
   FP \tab numeric \cr
   rSB \tab integer \cr
   rGFP \tab integer \cr
   rSZ \tab numeric \cr
   rCERA \tab integer \cr
   DRS \tab integer \cr
   Defense \tab numeric \cr
   CStrikes \tab numeric \cr
   CFraming \tab numeric \cr
   Q \tab numeric \cr
   TInn \tab numeric \cr
   teamid \tab integer \cr
   team_name_abb \tab character \cr
   rARM \tab integer \cr
   rPM \tab integer \cr
   BIZ \tab integer \cr
   Plays \tab integer \cr
   RZR \tab numeric \cr
   OOZ \tab integer \cr
   ARM \tab numeric \cr
   RngR \tab numeric \cr
   ErrR \tab numeric \cr
   UZR \tab numeric \cr
   UZR_150 \tab numeric \cr
   OAA \tab integer \cr
   rFRP \tab integer \cr
   rGDP \tab integer \cr
   DPR \tab numeric \cr
   Scp \tab integer \cr
}
}
\description{
This function allows you to scrape all leaderboard statistics (basic and advanced) from FanGraphs.com.
}
\examples{
\donttest{
  try(fg_fielder_leaders(startseason = 2023, endseason = 2023))
}
}
