% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chadwick_playername_lookup.R
\name{playername_lookup}
\alias{playername_lookup}
\title{\strong{Look up Baseball Player Name by ID}}
\usage{
playername_lookup(id)
}
\arguments{
\item{id}{An integer or character string representing a player ID in a baseball database, cross-referenced through the Chadwick Bureau's public register of baseball players.}
}
\value{
A data frame of baseball players and the various IDs associated with them in different systems of record.\tabular{ll}{
   col_name \tab types \cr
   name_first \tab character \cr
   name_last \tab character \cr
   name_given \tab character \cr
   name_suffix \tab character \cr
   name_nick \tab character \cr
   birth_year \tab integer \cr
   mlb_played_first \tab integer \cr
   key_mlbam \tab integer \cr
   key_retro \tab character \cr
   key_bbref \tab character \cr
   key_fangraphs \tab integer \cr
}
}
\description{
This function allows you to query the Chadwick Bureau's public register of baseball players and the various IDs associated with them in different systems of record.
}
\examples{
\donttest{
  try(playername_lookup(4885))
  try(playername_lookup("kaaihki01"))
}
}
