\name{meancenter}
\alias{meancenter}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Batch effect adjustment by mean-centering
}
\description{
Performs batch effect adjustment by centering the variables within batches to have zero mean.
}
\usage{
meancenter(x, batch)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
matrix. The covariate matrix of the new data. Observations in rows, variables in columns.
}
  \item{batch}{
factor. Batch variable. Each factor level (or 'category') corresponds to one of the batches. For example, if there are four batches, this variable would have four factor levels and observations with the same factor level would belong to the same batch.
}
}

\value{
\code{meancenter} returns an object of class \code{meancenter}.
An object of class "\code{meancenter}" is a list containing the following components: 
\item{xadj}{ matrix of adjusted (training) data }
\item{nbatches}{ number of batches }
\item{batch}{ batch variable }
}

\author{
Roman Hornung
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
data(autism)

params <- meancenter(x=X, batch=batch)
}
