% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{WMD_C}
\alias{WMD_C}
\alias{WMD_E}
\title{Scaled SVD Components from
World Marriage Database}
\format{
Object of class \code{"bage_ssvd"}.

Versions:
\itemize{
\item \code{"v2019"} (default) Data published in 2019
}
}
\source{
Derived from data from the
\emph{World Marriage Data 2019} database
available on the United Nations Population
Division website, and assembled by the
UNPD from national census and survey data.
Code to create \code{WMD}
is in folder \file{data-raw/ssvd_wmd}
in the source code for thet \pkg{bage}
package.
}
\usage{
WMD_C

WMD_E
}
\description{
Object of class \code{"bage_ssvd"}
holding scaled SVD components derived from
data from the census and survey data on marriage
assembled by the United Nations
Population Division.
\code{WMD_C} and \code{WMD_E} each hold 5 components.
}
\details{
\itemize{
\item \code{WMD_C} is based on data on the proportion
of the population that is currently married.
It should be used for modelling the proportion
of people whose marital status is
"Currently Married"
\item \code{WMD_E} is based on data on the proportion
of the population that has ever been married.
It should be used for modelling the proportion
of people whose marital status is
"Ever Married".
}

In both cases "marriage" includes de facto
marriages and consensual unions, in addition
to legal marriages.
}
\seealso{
\itemize{
\item \link[=svds]{Scaled SVDs} Overview of scaled SVDs
implemented in \pkg{bage}
\item \code{\link[=SVD]{SVD()}} A prior based on a scaled SVD
}
}
\keyword{datasets}
