% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-interactive.R
\name{AuthCodeCredential}
\alias{AuthCodeCredential}
\title{Authorization code credential authentication}
\description{
Authenticates a user through the OAuth 2.0 authorization code flow. This
flow opens a web browser for the user to sign in.
}
\details{
The authorization code flow is the standard OAuth 2.0 flow for interactive
authentication. It requires a web browser and is suitable for applications
where the user can interact with a browser window.

The credential supports token caching to avoid repeated authentication.
Tokens can be cached to disk or in memory. A redirect URI is required for
the OAuth flow to complete.
}
\examples{
# AuthCodeCredential requires an interactive session
\dontrun{
# Create credential with default settings
cred <- AuthCodeCredential$new(
  tenant_id = "your-tenant-id",
  client_id = "your-client-id",
  scope = "https://management.azure.com/.default"
)

# Get an access token (will open browser for authentication)
token <- cred$get_token()

# Force reauthentication
token <- cred$get_token(reauth = TRUE)

# Use with httr2 request
req <- httr2::request("https://management.azure.com/subscriptions")
req <- cred$req_auth(req)
}
}
\section{Super classes}{
\code{azr::Credential} -> \code{\link[azr:InteractiveCredential]{azr::InteractiveCredential}} -> \code{AuthCodeCredential}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AuthCodeCredential-new}{\code{AuthCodeCredential$new()}}
\item \href{#method-AuthCodeCredential-get_token}{\code{AuthCodeCredential$get_token()}}
\item \href{#method-AuthCodeCredential-req_auth}{\code{AuthCodeCredential$req_auth()}}
\item \href{#method-AuthCodeCredential-clone}{\code{AuthCodeCredential$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="print"><a href='../../azr/html/Credential.html#method-Credential-print'><code>azr::Credential$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="validate"><a href='../../azr/html/Credential.html#method-Credential-validate'><code>azr::Credential$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="InteractiveCredential" data-id="is_interactive"><a href='../../azr/html/InteractiveCredential.html#method-InteractiveCredential-is_interactive'><code>azr::InteractiveCredential$is_interactive()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuthCodeCredential-new"></a>}}
\if{latex}{\out{\hypertarget{method-AuthCodeCredential-new}{}}}
\subsection{Method \code{new()}}{
Create a new authorization code credential
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthCodeCredential$new(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  use_cache = "disk",
  offline = TRUE,
  redirect_uri = default_redirect_uri(),
  interactive = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{A character string specifying the OAuth2 scope. Defaults to \code{NULL}.}

\item{\code{tenant_id}}{A character string specifying the Azure Active Directory
tenant ID. Defaults to \code{NULL}.}

\item{\code{client_id}}{A character string specifying the application (client) ID.
Defaults to \code{NULL}.}

\item{\code{use_cache}}{A character string specifying the cache type. Use \code{"disk"}
for disk-based caching or \code{"memory"} for in-memory caching. Defaults to \code{"disk"}.}

\item{\code{offline}}{A logical value indicating whether to request offline access
(refresh tokens). Defaults to \code{TRUE}.}

\item{\code{redirect_uri}}{A character string specifying the redirect URI registered
with the application. Defaults to \code{\link[=default_redirect_uri]{default_redirect_uri()}}.}

\item{\code{interactive}}{A logical value indicating whether this credential
requires user interaction. Defaults to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AuthCodeCredential} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuthCodeCredential-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-AuthCodeCredential-get_token}{}}}
\subsection{Method \code{get_token()}}{
Get an access token using authorization code flow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthCodeCredential$get_token(reauth = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reauth}}{A logical value indicating whether to force reauthentication.
Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing the access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuthCodeCredential-req_auth"></a>}}
\if{latex}{\out{\hypertarget{method-AuthCodeCredential-req_auth}{}}}
\subsection{Method \code{req_auth()}}{
Add OAuth authorization code authentication to an httr2 request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthCodeCredential$req_auth(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{An \code{\link[httr2:request]{httr2::request()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The request object with OAuth authorization code authentication configured
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuthCodeCredential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AuthCodeCredential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthCodeCredential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
