% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_discover_poll_endpoint}
\alias{ecs_discover_poll_endpoint}
\title{Discover Poll Endpoint}
\usage{
ecs_discover_poll_endpoint(
  containerInstance = NULL,
  cluster = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{containerInstance}{Character. The container instance ID or full ARN of the container instance.}

\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance...}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Discover Poll Endpoint
}
\section{containerInstance}{

The container instance ID
or full ARN of the container instance. The ARN contains the
\code{arn:aws:ecs} namespace, followed by the Region of the container
instance, the AWS account ID of the container instance owner, the
\code{container-instance} namespace, and then the container instance ID. For
example,
\code{arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID}.
}

\section{cluster}{

The
short name or full Amazon Resource Name (ARN) of the cluster to which
the container instance belongs.
}

