% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_assign_ipv6_addresses}
\alias{ec2_assign_ipv6_addresses}
\title{Assign Ipv6 Addresses}
\usage{
ec2_assign_ipv6_addresses(
  NetworkInterfaceId,
  Ipv6AddressCount = NULL,
  Ipv6Addresses = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{NetworkInterfaceId}{Character. The ID of the network interface.}

\item{Ipv6AddressCount}{Integer. The number of additional IPv6 addresses to assign to the network interface.[optional]}

\item{Ipv6Addresses}{List. One or more specific IPv6 addresses to be assigned to the network interface.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Assign Ipv6 Addresses
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{Ipv6AddressCount}{

The number of additional IPv6 addresses
to assign to the network interface. The specified number of IPv6
addresses are assigned in addition to the existing IPv6 addresses that
are already assigned to the network interface. Amazon EC2 automatically
selects the IPv6 addresses from the subnet range. You can\'t use this
option if specifying specific IPv6 addresses.
}

\section{Ipv6Addresses}{

One or
more specific IPv6 addresses to be assigned to the network interface.
You can\'t use this option if you\'re specifying a number of IPv6
addresses.
}

