% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aws.ec2metadata-package.R
\docType{package}
\name{aws.ec2metadata-package}
\alias{aws.ec2metadata-package}
\alias{aws.ec2metadata}
\alias{is_ec2}
\alias{instance_document}
\alias{metadata}
\alias{is_ecs}
\alias{ecs_metadata}
\title{Get EC2 Instance Metadata}
\format{An object of class \code{list} of length 26.}
\usage{
is_ec2()

instance_document()

metadata

is_ecs()

ecs_metadata(base_url = "http://169.254.170.2")
}
\arguments{
\item{base_url}{Base URL for querying instance metadata}
}
\value{
\code{is_ec2()} and \code{is_ecs()} return a logical. Generally, all other functions will return a character string containing the requested information, otherwise a \code{NULL} if the response is empty. The \code{iam_role()} and \code{ecs_metadata()} functions return a list. An error will occur if, for some reason, the request otherwise fails.
}
\description{
Retrieve EC2 instance metadata from the instance
}
\details{
\code{is_ec2()} returns a logical for whether the current R session appears to be running in an EC2 instance. \code{is_ecs()} returns a logical for whether the current R session appears to be running in an ECS task container.

\code{instance_document} returns a list containing values from the \href{http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-identity-documents.html}{Instance Identity Document}, including the instance ID, AMI ID, region, availability zone, etc.

\code{metadata} is a list of functions to return various metadata values for the currently running EC2 instance. These are only meant to be called from an EC2 instance; no guarantees are made about behavior on other platforms. Two functions: \code{versions()} and \code{meta_data_items()} return the versions of the metadata, and the set of top-level metadata items, respectively.

The function \code{item()} retrieves a particular metadata item specified by its full path.

The remaining functions in the list are aliases for potentially commonly needed metadata items.

The environment variable \code{AWS_METADATA_SERVICE_TIMEOUT} controls the timeout for instance metadata checks, and defaults to 1 second.
}
\examples{
names(metadata)

\dontrun{
if (is_ec2()) {
  metadata$versions()
  metadata$items()

  # get instance id
  metadata$instance_id()
  # get ami id
  metadata$ami_id()
  
  # get IAM role (NULL if none specified)
  metadata$iam_info()
  metadata$iam_role("myrole")

  # get an arbitrary metadata item
  metadata$item("meta-data/placement/availability-zone")
  
  # get region from instance identity document
  instance_document()$region
}

# Can also get ECS container metadata
if (is_ecs()) {
  # Get ECS role credentials
  metadata$ecs_task_role()
  # or
  ecs_metadata()
}
}
}
\references{
\href{http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Metadata Documentation}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
\keyword{datasets}
\keyword{package}
