% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggstrat}
\alias{ggstrat}
\title{Plot a grainsize-depth stratigraphic section}
\usage{
ggstrat(
  df,
  section_name,
  grainsize_direction = c("increasing", "decreasing"),
  grainsize_labs = gs_volc_abbr,
  use_theme = NULL,
  xlim = c(-1, 10),
  ylim = NULL,
  depth_units = c("cm", "m"),
  ybreaks = 7,
  layer_fill = "layer_type",
  layer_fill_color = "stratpal_rpg",
  layer_border_color = "black",
  layer_border_linewidth = 0.2
)
}
\arguments{
\item{df}{A data frame containing stratigraphic data.
Must include columns \code{stratsection_name}, \code{stratlayer_order},
\code{grainsize}, \code{depth}, and \code{stratlayer_type}.}

\item{section_name}{Character string giving the section name to filter "stratsection_name".}

\item{grainsize_direction}{Character string, one of \code{"increasing"} or
\code{"decreasing"}. Controls the numeric mapping of grain sizes:
\itemize{
\item \code{"increasing"} (default): clay/silt = 1, ..., blocks/bombs/boulders = 10.
\item \code{"decreasing"}: clay/silt = 10, ..., blocks/bombs/boulders = 1.
}
Increasing will show coarser units as bigger polygons (more prominent)
which is espeically useful for emphasizing more energentic volcanic deposits.
Decreasing will show finer (typically more resistive) units as bigger
which may better match observed erosional profiles.}

\item{grainsize_labs}{Character vector of labels for the x-axis. Several predefined options are available:
\itemize{
\item \code{gs_volc_abbr}: Volcanic grainsize abbreviations (default).
\item \code{gs_sed_abbr}: Sedimentary grainsize abbreviations.
\item \code{gs_volc_names}: Volcanic grainsize full names.
\item \code{gs_sed_names}: Sedimentary grainsize full names.
\item \code{gs_numeric}: Numeric grainsize labels.
}}

\item{use_theme}{A ggplot2 theme object to apply to the plot, e.g., "theme_avstrat".}

\item{xlim}{Numeric vector of length 2 giving x-axis limits.}

\item{ylim}{Numeric vector of length 2 giving y-axis limits (optional).}

\item{depth_units}{Units to use for depth (y-axis) scale, either "cm" (default) or "m".}

\item{ybreaks}{Number of breaks on the y-axis.}

\item{layer_fill}{Character string naming the column to use for fill. If
using anything other than "layer_type" from the template, will need to make
a new palette.}

\item{layer_fill_color}{Palette object to use for fill colors.}

\item{layer_border_color}{Border color for polygons.}

\item{layer_border_linewidth}{Border line width for polygons.}
}
\value{
A ggplot object
}
\description{
Uses ggplot2 to create a grainsize vs. depth stratigraphic section plot.
}
\examples{
example_data_strat |>
 add_depths() |>
 ggstrat(section_name = "21LSHD02")
}
