% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Teste_Fisher.R
\name{teste.fisher}
\alias{teste.fisher}
\title{Teste exato de Fisher}
\usage{
teste.fisher(
  var1,
  var2,
  titulo = "Teste Exato de Fisher",
  x = NULL,
  y = "Proporcao",
  mostrar_tabela = TRUE,
  ajuda = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{var1}{Vetor categorico (fator ou caractere).}

\item{var2}{Vetor categorico (fator ou caractere).}

\item{titulo}{Titulo do gráfico (string). Default: "Teste Exato de Fisher"}

\item{x}{Nome do eixo x no gráfico (string). Default: NULL (usa nome da variável).}

\item{y}{Nome do eixo y no gráfico (string). Default: "Proporcao"}

\item{mostrar_tabela}{Lógico. Se TRUE, exibe a tabela de contingência no console. Default: TRUE.}

\item{ajuda}{Lógico. Se TRUE, mostra explicacao detalhada da função. Default: FALSE.}

\item{verbose}{Lógico. Se TRUE, imprime mensagens detalhadas sobre o teste. Default: TRUE.}
}
\value{
Uma lista com:
\describe{
\item{tabela}{Tabela de contingencia}
\item{p.valor}{Valor-p do teste}
}
}
\description{
Realiza o teste exato de Fisher a partir de dois vetores categoricos, construindo uma tabela de contingencia.
}
\examples{
Grupo_Pacientes <- c('A', 'A', 'B', 'B', 'A', 'A', 'B', 'B')
Doente <- c('Sim', 'Nao', 'Sim', 'Nao', 'Nao', 'Nao', 'Sim', 'Nao')
teste.fisher(Grupo_Pacientes, Doente)

}
