% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_clone}
\alias{am_clone}
\title{Clone an Automerge document}
\usage{
am_clone(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A new Automerge document (independent copy with same actor ID)
}
\description{
Creates an independent deep copy of an Automerge document, preserving
the same actor ID. Changes to the clone do not affect the original,
and vice versa.
}
\details{
Unlike \code{\link[=am_fork]{am_fork()}}, which assigns a new actor ID to the copy,
\code{am_clone()} preserves the original actor ID. This makes it suitable
for archival snapshots or checkpoints where you want an exact copy of
the document state. Do not use \code{am_clone()} to create branches that
will make independent edits and later be merged — use \code{\link[=am_fork]{am_fork()}}
for that, as two documents sharing an actor ID can cause conflicts.
}
\examples{
doc <- am_create()
doc$key <- "value"
am_commit(doc)

clone <- am_clone(doc)
clone$key  # "value"

# Clone preserves the actor ID
am_get_actor_hex(doc) == am_get_actor_hex(clone) # TRUE

# Changes to clone don't affect original
clone$key <- "changed"
doc$key  # still "value"

am_close(doc)
am_close(clone)

}
\seealso{
\code{\link[=am_fork]{am_fork()}} for creating branches with a new actor ID
}
