% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_parametric}
\alias{check_parametric}
\title{Internal: Check if a numeric vector follows a normal distribution}
\usage{
check_parametric(data)
}
\arguments{
\item{data}{A numeric vector to test for normality.}
}
\value{
A list containing:
\describe{
  \item{test}{Name of the test used ("Shapiro-Wilk Test" or "Anderson-Darling Test")}
  \item{statistic}{The test statistic}
  \item{p_value}{The p-value from the test}
  \item{result}{Logical; \code{TRUE} if p > 0.05 (assumed normal), \code{FALSE} otherwise}
}

Returns \code{NULL} if input is not numeric.
}
\description{
This function checks whether a numeric vector is approximately normally distributed,
using the Shapiro-Wilk test for small samples (n < 5000) and the Anderson-Darling test
for larger ones. If the input is not numeric, the function returns \code{NULL}.
}
\keyword{internal}
