% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_packages.R
\name{parse_packages}
\alias{parse_packages}
\title{Parse R code for required packages}
\usage{
parse_packages(fl)
}
\arguments{
\item{fl}{file to parse for required package names}
}
\value{
a vector of package names as character strings
}
\description{
Parses an R or R Markdown file for the package names that would be required to run the code.
}
\details{
This function uses regular expressions to search through a file
  containing R code to find required package names.  It extracts not only
  package names denoted by \code{\link[base]{library}} and \code{\link[base]{require}}, but also
  packages not attached to the global namespace, but are still called with
  \code{\link[base]{::}} or \code{\link[base]{:::}}.

  Because it relies on regular expressions, it assumes all packages adhere to
  the valid CRAN package name rules (contain only ASCII letters, numbers, and
  dot; have at least two characters and start with a letter and not end it a
  dot). Code is also tidying internally, making the code more predictable and
  easier to parse (removes comments, adds whitespace around operators, etc).
  R Markdown files are also supported by extracting only R code using
  \code{\link[knitr]{purl}}.
}
\examples{
\dontrun{
cat('library(ggplot2)\\n # library(curl)\\n require(leaflet)\\n CB::date_print()\\n',file='temp.R')
parse_packages('temp.R')
unlink('temp.R')
}
}
\seealso{
\code{\link{install_package_guess}}, \code{\link{automagic}}
}
