% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{my.predictions}
\alias{my.predictions}
\title{Make predictions with selected algorithms}
\usage{
my.predictions(
  bestmod = NULL,
  prepedTS = NULL,
  algos = list("my.prophet", "my.ets", "my.sarima", "my.tbats", "my.bats", "my.stlm",
    "my.shortterm"),
  n_pred = NA
)
}
\arguments{
\item{bestmod}{A list produced by the \code{getBestModel()} function (optional if \code{prepredTS} is provided)}

\item{prepedTS}{A list created by the \code{prepare.ts()} function (optional if \code{bestmod} provided)}

\item{algos}{A list containing the algorithms to be implemented. If \code{bestmod} is supplied, this value is ignored, and taken from the best model object
Using this option will overwrite the provided list of algorithms to implement them all}

\item{n_pred}{Int number of periods to forecast forward (eg n_pred = 12 will lead to one year of prediction for monthly time series)}
}
\value{
A dataframe containing : date, actual observed values, one column per used algorithm, and
a column indicating the type of measure (mean prediction, upper or lower bound of CI)
}
\description{
Fit selected algorithms, make the predictions and combine
the results along with observed data in one final dataframe.
}
\examples{
library(lubridate)
library(dplyr)
dates <- seq(lubridate::as_date("2000-01-01"),lubridate::as_date("2010-12-31"),"quarter")
values <- 10+ 1:length(dates)/10 + rnorm(length(dates),mean = 0,sd = 10)
### Stand alone usage
prepare.ts(dates,values,"quarter") \%>\%
  my.predictions(prepedTS = .,algos = list("my.prophet","my.ets"))
### Standard input with bestmodel
\donttest{
getBestModel(dates,values,freq = "quarter",n_test = 6) \%>\%
  my.predictions()
}

}
