% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs.R
\name{get_relative_risk}
\alias{get_relative_risk}
\title{Compute relative risk for each of the covariates with respect to outcomes occurred}
\usage{
get_relative_risk(df, outcomeVec)
}
\arguments{
\item{df}{The input \code{data.frame}. Ideally this should be the output \code{recurrence_data} from the
\code{\link[autoCovariateSelection]{get_recurrence_covariates}} function. The first column should be the patient identifier column and
all other columns should be binary covariates. The values of these binary columns should be 1 indicating occurrence of covariate and 0 indicating
no occurrence of the covariate.}

\item{outcomeVec}{The 1-D outcome vector indicating whether or not the patient experienced the outcome of interest (value = 1) or not (value =0).
The length of this vector should be equal to the number of rows of \code{df}. The order of elements in this vector should resonate with
the order of patients in \code{df}}
}
\value{
A 1-D vector containing relative risk of the association between the covariate (confounder) and the outcome. Thus, the length of this vector
will be equal to the number of covariates.
}
\description{
\code{get_relative_risk} function is a helper function used within the \code{\link[autoCovariateSelection]{get_prioritised_covariates}} function.
This function computes the prevalence in the exposed and that in the unexposed and simply returns the relative risk for all the covariates in the
input \code{data.frame}
}
\author{
Dennis Robert \email{dennis.robert.nm@gmail.com}
}
