% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_HOR_EQD}
\alias{astro_rotation_HOR_EQD}
\title{Rotation Matrix from HOR to EQD}
\usage{
astro_rotation_HOR_EQD(time, latitude, longitude, height)
}
\arguments{
\item{time}{A POSIXct object representing the date and time at which the Earth's
equator applies.}

\item{latitude}{The observer's geographic latitude in degrees.}

\item{longitude}{The observer's geographic longitude in degrees.}

\item{height}{The observer's elevation above sea level in meters.}
}
\value{
A rotation matrix that converts HOR to EQD.
}
\description{
Calculates a rotation matrix from horizontal (HOR) to equatorial of-date (EQD).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: HOR = horizontal system (x = north, y = west, z = zenith).

\strong{Target}: EQD = equatorial system, using equator of the specified date/time.
}
\examples{
astro_rotation_HOR_EQD(Sys.time(), latitude = -35.28, longitude = 149.12, height = 0)

}
