% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQD_ECT}
\alias{astro_rotation_EQD_ECT}
\title{Rotation Matrix from EQD to ECT}
\usage{
astro_rotation_EQD_ECT(time)
}
\arguments{
\item{time}{A POSIXct object representing the date and time of the equator/ecliptic
conversion.}
}
\value{
A rotation matrix that converts EQD to ECT.
}
\description{
Calculates a rotation matrix from equator of date (EQD) to true ecliptic
of date (ECT).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQD = equator of date.

\strong{Target}: ECT = true ecliptic of date.
}
\examples{
astro_rotation_EQD_ECT(Sys.time())

}
