% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_finder.R
\name{summarise_model}
\alias{summarise_model}
\title{Summarise the model functions in a single folder.}
\usage{
summarise_model(
  project_path = ".",
  foo_folder = "R",
  exclude_files = NULL,
  exclude_dirs = NULL,
  test_folder = NULL,
  output_format = "dataframe"
)
}
\arguments{
\item{project_path}{path to the project folder, if not provided, will use current working directory.}

\item{foo_folder}{path to folder containing all functions for the model}

\item{exclude_files}{A regular expression for files to NOT process (basename)}

\item{exclude_dirs}{A regular expression for directories to NOT process (dirname)}

\item{test_folder}{folder containing all tests}

\item{output_format}{output format to use, defaults to dataframe, options include latex and word.}
}
\value{
dataframe with three columns. 'foo_string' contains function names, 'foo_location'
contains the location of the function definitions, 'test_location' contains the locations
of tests for each function (both file and line number).
}
\description{
Summarise the model functions in a single folder.
}
\examples{
project_path <- assertHE_example("example_project")
foo_folder  <- "R"
test_folder <- "tests/testthat"

summarise_model(
  project_path = project_path,
  foo_folder = foo_folder,
  test_folder =  test_folder
)

summarise_model(
  project_path = project_path,
  foo_folder = foo_folder,
  test_folder =  NULL
)

}
