##################################################################################
#                                                                                #
#  Analysis of Symmetry of Parasitic Infections (ASPI)                           #
#                                                                                #
#  Version 0.2                                                                   #
#                                                                                #
#  Copyright (C) 2016 Matthew Thomas Wayland                                     #
#                                                                                #
#  This file is part of Analysis of Symmetry of Parasitic Infections.            #
#                                                                                #
#  Analysis of Symmetry of Parasitic Infections is free software: you can        #
#  redistribute it and/or modify it under the terms of the GNU General Public    #
#  License as published by the Free Software Foundation, either version 3 of     #
#  the License, or (at your option) any later version.                           #
#                                                                                #
#  Analysis of Symmetry of Parasitic Infections is distributed in the hope that  #
#  it will be useful, but WITHOUT ANY WARRANTY; without even the implied         #
#  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     #
#  GNU General Public License for more details.                                  #
#                                                                                #
#  You should have received a copy of the GNU General Public License along       #
#  with Analysis of Symmetry of Parasitic Infections.                            #
#  If not, see <http://www.gnu.org/licenses/>.                                   #
#                                                                                #
#                                                                                #
##################################################################################

#' ASPI: Analysis of Symmetry in Parasitic Infections
#'
#' Tools for the analysis and visualization of bilateral asymmetry in
#' parasitic infections.
#' 
#' @section Functions:
#' \itemize{
#' \item{\code{g.test}}
#' \item{\code{eb.test}}
#' \item{\code{plotHistogram}}
#' \item{\code{plotVolcano}}
#' }
#' 
#' @section Data:
#' \itemize{
#' \item{\code{diplostomum_eyes_excl_lenses}}
#' \item{\code{diplostomum_lenses}}
#' \item{\code{simulated_symmetrical_infection}}
#' \item{\code{simulated_left_bias_homogeneous_proportions}}
#' \item{\code{simulated_left_bias_heterogeneous_proportions}}
#' \item{\code{simulated_asymmetry_inconsistent_bias}}
#' }
#'
#' @author Matt Wayland, \email{mw283@cam.ac.uk}
#'
#' @docType package
#' @name aspi
NULL