% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{asm.fit}
\alias{asm.fit}
\title{Fit a linear regression model via antitonic score matching}
\usage{
asm.fit(
  X,
  Y,
  betapilot = "LAD",
  error_quantile = NULL,
  symmetric = TRUE,
  alt_iter = 2,
  intercept.selection = "mean",
  k = 3000,
  max_iter = 200,
  kernel_pts = 2^15,
  bw = "nrd0",
  kernel = "gaussian",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{design matrix}

\item{Y}{response vector}

\item{betapilot}{initial estimate of the regression coefficients:
can be "LAD", "OLS" or a vector of coefficients}

\item{error_quantile}{quantile of the residuals to be returned as intercept
Used only if intercept.selection = "quantile"
If error_quantile = 0.5, then the intercept is the median of the residual
Ignored if symmetric = TRUE}

\item{symmetric}{logical; if TRUE, estimate a symmetric loss function}

\item{alt_iter}{number of iterations of the alternating procedure:
when alt_iter == 1, this function is equivalent to asm_regression}

\item{intercept.selection}{mean, median, or quantile of the residuals
If intercept.selection = "quantile", then error_quantile specifies the quantile value
Ignored if symmetric == TRUE}

\item{k}{the density quantile function is evaluated at (0, 1/\code{k}, 2/\code{k}, ..., 1)}

\item{max_iter}{maximum number of iterations for the damped Newton–Raphson algorithm
when minimizing the convex loss function}

\item{kernel_pts}{number of points at which the kernel density estimate is evaluated,
i.e. the parameter "n" in density()}

\item{bw}{bandwidth for kernel density estimation
i.e. the parameter "bw" in density()}

\item{kernel}{kernel for kernel density estimation
i.e. the parameter "kernel" in density()}

\item{verbose}{logical; if TRUE, print optimization progress}

\item{...}{additional arguments to ensure compatibility with generic functions}
}
\value{
\code{asm} class object containing the following components:
\describe{
 \item{\code{betahat}:}{vector of estimated coefficients}
 \item{\code{std_errs}:}{vector of standard errors of the estimated coefficients}
 \item{\code{fitted.values}:}{fitted values}
 \item{\code{residuals}:}{residuals}
 \item{\code{zvals}:}{z-values}
 \item{\code{sig_vals}:}{p-values}
 \item{\code{info_asm}:}{estimated antitonic information}
 \item{\code{I_mat}:}{estimated antitonic information matrix}
 \item{\code{Cov_mat}:}{asymptotic covariance matrix of the estimated coefficients}
 \item{\code{psi}:}{estimated antitonic score function}
 \item{\code{symmetric}:}{logical; indicating whether the loss is constrained to be symmetric}
}
}
\description{
Performs linear regression via M-estimation with respect to a data-driven convex loss function
}
\examples{
n <- 1000 ; d <- 2
X <- matrix(rnorm(n * d), n, d)
Y <- X \%*\% c(2, 3) + 1 + rnorm(n)
asm.fit(X, Y)

Y <- X \%*\% c(2, 3) + rexp(n)
asm.fit(X, Y, symmetric=FALSE)
}
