% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Agrawal_data.R
\docType{data}
\name{Agrawal}
\alias{Agrawal}
\alias{Agrawal.pat}
\alias{Agrawal.db}
\title{Synthetic Example Dataset Agrawal}
\format{
The format is: \code{transactions} \code{Agrawal.db} \code{itemsets}
\code{Agrawal.pat}
}
\description{
This dataset is generated by the method described by Agrawal and Srikant
(1994) using the reimplementation in \pkg{arules} which also retains the
patterns used in the generation process.
}
\details{
\code{Agrawal.db} contains the dataset (1000 items/20000 transactions) and
\code{Agrawal.pat} contains the patterns that were used to create the
dataset.
}
\examples{
data(Agrawal)

summary(Agrawal.pat)
summary(Agrawal.db)

## the data sets was generated with the following code
\dontrun{
Agrawal.pat <- random.patterns(1000, nPats = 2000,  method = "agrawal",
    lPats = 2, corr = 0.5, cmean = 0.5, cvar = 0.1, iWeight = NULL,
    verbose = FALSE)
Agrawal.db <- random.transactions(1000, 20000, method="agrawal",
    patterns = Agrawal.pat)
}
}
\references{
Rakesh Agrawal and Ramakrishnan Srikant (1994). Fast algorithms
for mining association rules in large databases. In Jorge B.  Bocca,
Matthias Jarke, and Carlo Zaniolo, editors, \emph{Proceedings of the 20th
International Conference on Very Large Data Bases, VLDB}, pages 487-499,
Santiago, Chile.
}
\keyword{datasets}
