% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc_helpers.R
\name{perform_posthoc}
\alias{perform_posthoc}
\title{Perform Post-Hoc Tests}
\usage{
perform_posthoc(
  model,
  data,
  response,
  treatment,
  mse,
  df_error,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{model}{ANOVA model object}

\item{data}{Data frame}

\item{response}{Response variable name}

\item{treatment}{Treatment factor name}

\item{mse}{Mean square error}

\item{df_error}{Error degrees of freedom}

\item{posthoc}{Test type: "lsd", "duncan", "tukey", "snk", "scheffe", or "all"}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing post-hoc test results
}
\description{
Performs multiple comparison tests after ANOVA.
}
