% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arf-package.R
\docType{package}
\name{arf-package}
\alias{arf}
\alias{arf-package}
\title{arf: Adversarial Random Forests}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Adversarial random forests (ARFs) recursively partition data into fully factorized leaves, where features are jointly independent. The procedure is iterative, with alternating rounds of generation and discrimination. Data becomes increasingly realistic at each round, until original and synthetic samples can no longer be reliably distinguished. This is useful for several unsupervised learning tasks, such as density estimation and data synthesis. Methods for both are implemented in this package. ARFs naturally handle unstructured data with mixed continuous and categorical covariates. They inherit many of the benefits of random forests, including speed, flexibility, and solid performance with default parameters. For details, see Watson et al. (2023) \url{https://proceedings.mlr.press/v206/watson23a.html}.
}
\examples{
# Train ARF and estimate leaf parameters
arf <- adversarial_rf(iris)
psi <- forde(arf, iris)

# Generate 100 synthetic samples from the iris dataset
x_synth <- forge(psi, n_synth = 100)

# Condition on Species = "setosa" and Sepal.Length > 6
evi <- data.frame(Species = "setosa",
                  Sepal.Length = "(6, Inf)")
x_synth <- forge(psi, n_synth = 100, evidence = evi)

# Estimate average log-likelihood
ll <- lik(psi, iris, arf = arf, log = TRUE)
mean(ll)

# Expectation of Sepal.Length for class setosa
evi <- data.frame(Species = "setosa")
expct(psi, query = "Sepal.Length", evidence = evi)

\dontrun{
# Parallelization with doParallel
doParallel::registerDoParallel(cores = 4)

# ... or with doFuture
doFuture::registerDoFuture()
future::plan("multisession", workers = 4)
}
}
\seealso{
\code{\link{adversarial_rf}}, \code{\link{forde}}, \code{\link{forge}},
\code{\link{expct}}, \code{\link{lik}}

Useful links:
\itemize{
\item \url{https://github.com/bips-hb/arf}
\item \url{https://bips-hb.github.io/arf/}
\item Report bugs at \url{https://github.com/bips-hb/arf/issues}
}
}
\author{
\strong{Maintainer}: Marvin N. Wright \email{cran@wrig.de} (\href{https://orcid.org/0000-0002-8542-6291}{ORCID})

Authors:
\itemize{
  \item David S. Watson \email{david.s.watson11@gmail.com} (\href{https://orcid.org/0000-0001-9632-2159}{ORCID})
  \item Kristin Blesch (\href{https://orcid.org/0000-0001-6241-3079}{ORCID})
  \item Jan Kapar (\href{https://orcid.org/0009-0000-6408-2840}{ORCID})
}

}
