% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arena.R
\name{push_dataset}
\alias{push_dataset}
\title{Adds new datasets to Arena}
\usage{
push_dataset(arena, dataset, target, label)
}
\arguments{
\item{arena}{live or static arena object}

\item{dataset}{data frame used for EDA plots}

\item{target}{name of target variable}

\item{label}{label of dataset}
}
\value{
Updated arena object
}
\description{
Adds data frame to create exploratory data analysis plots
}
\examples{
library("DALEX")
library("arenar")
library("dplyr", quietly=TRUE, warn.conflicts = FALSE)
# create live arena with only one dataset
apartments <- DALEX::apartments
arena <- create_arena(live=TRUE) \%>\% push_dataset(apartments, "m2.price", "apartment")
print(arena)
# add another dataset
HR <- DALEX::HR
arena <- arena \%>\% push_dataset(HR, "status", "HR")
print(arena)
}
