% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.r
\name{da_drop}
\alias{da_drop}
\title{Table Row Removal with arcpy.da}
\usage{
da_drop(table.path, rows)
}
\arguments{
\item{table.path}{The file path to the table.}

\item{rows}{The row indexes to drop.}
}
\value{
(Invisible) The path to the table, i.e. \code{table.path}.
}
\description{
Drop records from a table (e.g. attribute table of a layer)
with the arcpy.da module.
}
\examples{
\dontrun{
arcpy$env$workspace = tempdir()
arcpy$env$scratchWorkspace = tempdir()
fc = arcpy$management$CopyFeatures(system.file("CA_Counties",
  "CA_Counties_TIGER2016.shp", package = "arcpy"), "CA_Counties")
d = da_read(fc, c("STATEFP", "COUNTYFP"))
drop.rows = which(d$STATEFP == "06" & d$COUNTYFP == "067")
da_drop(fc, drop.rows)
}

}
