% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{wilson2022}
\alias{wilson2022}
\title{Example Data from Wilson et al. 2022}
\format{
A \code{SoilProfileCollection} with the following elements. Total elemental analysis by lithium borate fusion.

Horizon level attributes:
\itemize{
\item name: horizon designation
\item Al2O3: total Al (wt \%)
\item Fe2O3: total Fe (wt \%)
\item K2O: total K (wt \%)
\item MgO: total Mg (wt \%)
\item Na2O: total Na (wt \%)
\item P2O5: total P (wt \%)
\item SiO2: total Si (wt \%)
\item CaO: total Ca(wt \%)
\item Alo: Oxalate Extractable Al (g/kg)
\item Feo: Oxalate Extractable Fe (g/kg)
\item Fed: Dithionite extractable Fe (g/kg)
\item Fed_minus_Feo: Crystalline Fe (hydr)oxides (g/kg)
\item CIA: Chemical Index of Alteration, see original paper (ratio, unitless)
\item Fed_div_Fet: (ratio, unitless)
\item Fet: Total Fe from lithium borate fusion (g/kg)
\item resin_Pi: Hedley phosphorus fractions (mg/kg)
\item NaHCO3_Pi: Hedley phosphorus fractions (mg/kg)
\item labile_Pi: Sum of resin Pi and NaHCO3 Pi (mg/kg)
\item NaCO3_Po: Hedley phosphorus fractions (mg/kg)
\item NaOH_Pi: Hedley phosphorus fractions (mg/kg)
\item NaOH_Po: Hedley phosphorus fractions (mg/kg)
\item Ca_Pi: Hedley phosphorus fractions (mg/kg)
\item organic_P: Sum of NaHCO3 and NaOH Po fractions (mg/kg)
\item total_P: Total P from lithium borate fusion (mg/kg)
\item occluded_P: Difference between total P and sum of Hedley P fractions (mg/kg)
\item top: horizon top depth (cm)
\item bottom: horizon bottom depth (cm)
\item pedonID: pedon ID (serial number)
}

Site level attributes:
\itemize{
\item pm: parent material group
\item biome: biome
}
}
\usage{
data(wilson2022)
}
\description{
An example \code{SoilProfileCollection}, derived from Wilson et al., 2022. Select data extracted from Appendix tables.
}
\examples{

data(wilson2022)

groupedProfilePlot(wilson2022, groups = 'pm', 
group.name.offset = -15, label = 'biome', 
name.style = 'center-center', color = 'CIA', 
cex.names = 0.66, cex.id = 0.66, width = 0.3)

groupedProfilePlot(wilson2022, groups = 'biome', 
group.name.offset = -15, label = 'pm', 
name.style = 'center-center', color = 'Fet', 
cex.names = 0.66, cex.id = 0.66, width = 0.3)

}
\references{
Stewart G. Wilson, Randy A. Dahlgren, Andrew J. Margenot, Craig Rasmussen, Anthony T. O'Geen. 2022. Expanding the Paradigm: The influence of climate and lithology on soil phosphorus, Geoderma: 421. \doi{10.1016/j.geoderma.2022.115809}
}
\keyword{datasets}
