% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data_apsimx.R
\name{extract_data_apsimx}
\alias{extract_data_apsimx}
\title{Extract data from an .apsimx (JSON) file}
\usage{
extract_data_apsimx(
  file = "",
  src.dir = ".",
  node = c("Clock", "Weather", "Soil", "SurfaceOrganicMatter", "MicroClimate", "Crop",
    "Manager", "Report", "Operations", "Other"),
  soil.child = c("Metadata", "Water", "InitialWater", "Chemical", "Physical", "Analysis",
    "SoilWater", "InitialN", "CERESSoilTemperature", "Sample", "Solute", "NO3", "NH4",
    "Urea", "Nutrient", "Organic", "Swim3"),
  parm = NULL,
  digits = 3,
  root = NULL
)
}
\arguments{
\item{file}{file ending in .apsimx to be inspected (JSON)}

\item{src.dir}{directory containing the .apsimx file to be inspected; defaults to the current working directory}

\item{node}{specific node to be used either \sQuote{Clock}, \sQuote{Weather},
\sQuote{Soil}, \sQuote{SurfaceOrganicMatter}, \sQuote{MicroClimate}, \sQuote{Crop},
 \sQuote{Manager}, \sQuote{Operations} or \sQuote{Other}}

\item{soil.child}{specific soil component to be inspected. The options vary depending on what is available (see \link{inspect_apsimx})}

\item{parm}{parameter to refine the extraction of the \sQuote{manager} list(\sQuote{parm},\sQuote{position}), use \sQuote{NA} for all the positions. \sQuote{parm} can be a regular expression for partial matching.}

\item{digits}{number of decimals to print (default 3). Not used now because everything is a character.}

\item{root}{root node label. In simulation structures such as factorials there will be multiple possible nodes. This can be specified by supplying an appropriate character.}
}
\value{
a \link{data.frame} or a \link{list}. It does not return a path.
}
\description{
Extract data from a JSON apsimx file.
}
\details{
This function does not print anything (compared to inspect_apsimx). The purpose is to return data
contained in the APSIM simulation as a data.frame. It will return a \sQuote{list} when a data frame
does not naturally accommodate the result. For example, the complete manager node does not naturally
fit into a data frame structure. In some cases, multiple data frames are returned as part of lists.

Have not written this section yet
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Clock"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Weather"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "Metadata"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "Physical"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "SoilWater"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "Organic"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "Chemical"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "InitialWater"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil",
soil.child = "InitialN"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "SurfaceOrganicMatter"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "MicroClimate"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Crop"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Manager"))
(edf <- extract_data_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Report"))
}

}
