% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/version_log.R
\name{version_log}
\alias{version_log}
\title{Create and maintain a dataset version log}
\usage{
version_log(
  df,
  name,
  file = NULL,
  prevdata = NULL,
  template = NULL,
  comp_var,
  src_data = "",
  font = "Times New Roman",
  size = 9,
  orient = "landscape"
)
}
\arguments{
\item{df}{filepath of new dataset}

\item{name}{name of the dataset (filename with .csv suffix)}

\item{file}{filepath for version log file (.docx)}

\item{prevdata}{comparison dataset filepath}

\item{template}{template docx filepath}

\item{comp_var}{grouping variables for comparison}

\item{src_data}{string to describe source data}

\item{font}{font style}

\item{size}{font size}

\item{orient}{document orientation}
}
\value{
version log as a .docx file
}
\description{
Version log is outputted as a .docx file.
Document tracks changes in subject count, record count, new variables, and changing variables.
User comments in the word document are preserved between versions.
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create with pk_build()
df <- pk_build(ex, pc)

## Document with version_log()
vlog <- version_log(df, name = "PK_DATA_V01.csv")

}
