% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_write.R
\name{pk_write}
\alias{pk_write}
\title{Write PK(PD) dataset to specified location}
\usage{
pk_write(df, file)
}
\arguments{
\item{df}{PK(PD) dataframe}

\item{file}{filepath}
}
\value{
writes dataset to specified location
}
\description{
Dataset created by pk_build() or pk_combine() will be outputted as a .csv file with NONMEM-standard formatting.
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create with pk_build()
df <- pk_build(ex, pc)

## Write with pk_write()
name <- "dataset.csv"
pk_write(df, file.path(tempdir(), name))

}
