% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_combine.R
\name{pk_combine}
\alias{pk_combine}
\title{combine study level datasets to form population dataset}
\usage{
pk_combine(df1, df2, demo.map = TRUE, na = -999)
}
\arguments{
\item{df1}{original PK(PD) dataset}

\item{df2}{additional PK(PD) dataset}

\item{demo.map}{toggle pre-set numeric values for SEX, RACE, and ETHNIC demographic variables}

\item{na}{value for missing numeric items}
}
\value{
population PK(PD) dataset
}
\description{
Input two datasets created by pk_build().
Any character descriptions that were numerically mapped will be re-mapped to the whole population.
}
\examples{
## Simple ex domain with 1 subject and 1 dose, study 101
ex101 <- data.frame(STUDYID = "ABC101",
                    USUBJID = "ABC101-001",
                    EXSTDTC = "2000-01-01 10:00:00",
                    EXSTDY = 1,
                    EXTPTNUM = 0,
                    EXDOSE = 100,
                    CMT = 1,
                    EXTRT = "ABC",
                    EXDOSU = "mg",
                    VISIT = "Day 1",
                    EXTPT = "Dose",
                    EXDOSFRQ = "Once",
                    EXROUTE = "Oral")

## Simple ex domain with 1 subject and 1 dose, study 102
ex102 <- data.frame(STUDYID = "ABC102",
                    USUBJID = "ABC102-001",
                    EXSTDTC = "2001-01-01 08:09:00",
                    EXSTDY = 1,
                    EXTPTNUM = 0,
                    EXDOSE = 200,
                    CMT = 1,
                    EXTRT = "ABC",
                    EXDOSU = "mg",
                    VISIT = "Day 1",
                    EXTPT = "Dose",
                    EXDOSFRQ = "QW",
                    EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations, study 101
pc101 <- data.frame(USUBJID = "ABC101-001",
                    PCDTC = c("2000-01-01 09:40:00",
                              "2000-01-01 10:29:00",
                              "2000-01-01 12:05:00"),
                    PCDY = 1,
                    PCTPTNUM = c(0, ##Units of hours
                                 0.021,
                                 0.083),
                    PCSTRESN = c(NA,
                                 469,
                                 870),
                    PCLLOQ = 25,
                    CMT = 2,
                    VISIT = "Day 1",
                    PCTPT = c("Pre-dose",
                              "30-min post-dose",
                              "2-hr post-dose"),
                    PCTEST = "ABC",
                    PCSTRESU = "ug/mL")

## Simple pc domain with 1 subject and 3 observations, study 102
pc102 <- data.frame(USUBJID = "ABC102-001",
                    PCDTC = c("2001-01-01 08:05:00",
                              "2001-01-01 11:38:00",
                              "2001-01-02 08:11:00"),
                    PCDY = 1,
                    PCTPTNUM = c(0, ##Units of hours
                                 0.125,
                                 1),
                    PCSTRESN = c(NA,
                                 1150,
                                 591),
                    PCLLOQ = 25,
                    CMT = 2,
                    VISIT = "Day 1",
                    PCTPT = c("Pre-dose",
                              "2-4 hr post-dose",
                              "24 hr post-dose"),
                    PCTEST = "ABC",
                    PCSTRESU = "ug/mL")

## Create with pk_build()
df101 <- pk_build(ex101, pc101)
df102 <- pk_build(ex102, pc102)

## Combine with pk_combine()
df_combine <- pk_combine(df101, df102)

}
