% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_build.R
\name{pk_build}
\alias{pk_build}
\title{Create a NONMEM PK(PD) dataset}
\usage{
pk_build(
  ex,
  pc = NA,
  pd = NA,
  sl.cov = NA,
  tv.cov = NA,
  time.units = "days",
  cycle.length = NA,
  na = -999,
  time.rnd = NULL,
  amt.rnd = NULL,
  dv.rnd = NULL,
  cov.rnd = NULL,
  impute = NA,
  BDV = FALSE,
  DDV = FALSE,
  PDV = FALSE,
  sparse = 3,
  demo.map = TRUE,
  tv.cov.fill = "downup",
  keep.other = TRUE
)
}
\arguments{
\item{ex}{dose event dataframe}

\item{pc}{pc event dataframe}

\item{pd}{pd event dataframe}

\item{sl.cov}{subject-level covariate dataframe}

\item{tv.cov}{time-varying covariate dataframe}

\item{time.units}{units for time attributes}

\item{cycle.length}{cycle length in units of days}

\item{na}{value for missing numeric items}

\item{time.rnd}{time attribute rounding parameter}

\item{amt.rnd}{amount attribute rounding parameter}

\item{dv.rnd}{dependent variable attribute rounding parameter}

\item{cov.rnd}{covariate attribute rounding parameter}

\item{impute}{imputation method}

\item{BDV}{baseline pd attribute}

\item{DDV}{change from baseline pd attribute}

\item{PDV}{percent change from baseline pd attribute}

\item{sparse}{threshold for sparse sampling}

\item{demo.map}{toggle pre-set numeric values for SEX, RACE, and ETHNIC demographic variables}

\item{tv.cov.fill}{time-varying covariate fill direction}

\item{keep.other}{filter to keep or remove other events, EVID = 2}
}
\value{
PK(PD) dataset
}
\description{
Input a pre-processed ex and pc domain for combination into a NONMEM dataset.
Additional pd endpoints, subject-level covariates, and time-varying covariates can also be added.
Other parameters can customize some calculations and formatting.
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create with pk_build()
df <- pk_build(ex, pc)

}
